<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns="http://www.w3.org/1999/xhtml">
    
    <xsl:output
    method="html"
    encoding="UTF-16"
    doctype-public="-//W3C//DTD XHTML 1.1//EN"
    doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
    indent="yes"
    cdata-section-elements="style script"/>
    
    <xsl:template match="/root">
        <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
            <head>
                <meta http-equiv="content-type" content="text/html; charset=utf-16" />
                <link rel="stylesheet" href="../css-dark/default.css" type="text/css" media="all" charset="utf-8" />
                <link rel="stylesheet" href="../css-dark/overview_section.css" type="text/css" media="all" charset="utf-8" />
                <link rel="stylesheet" href="../css-dark/zero_states.css" media="all" charset="utf-8" type="text/css" />
                
                <script type="text/javascript" src="../js/jquery-1.10.2.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/jquery_accounts_expander.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/overview.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/spendingTrends.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/upcomingTransactions.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/budgetGoals.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/quickzoomTx.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/deferredPrinting.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/utils.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/highcharts.js" charset="utf-8"></script>
                <script type="text/javascript" src="../js/slider.js" charset="utf-8"></script>
                <script type="text/javascript">
                    $(OverviewInit);
                </script>
            </head>
            
            <body id="overview">
                <div id="outerWrapper">
                    
                    <xsl:choose>
                        <!-- Do we have any accounts? -->
                        <xsl:when test="count(/root/*)">
                            <div id="innerWrapper">
                                <xsl:apply-templates select="currencies"/>
                                <h1 id="pageTitle">Overview</h1>
                                
                                <!-- Spending Trends -->
                                <div id="stepACont" class="clearAfter section">
                                    <xsl:apply-templates select="spendingTrendsDates"/>
                                    
                                    <xsl:choose>
                                        <!-- Do we have any payees? -->
                                        <xsl:when test="count(spendingTrendsPart) and count(spendingTrendsPart/payee)">
                                            <xsl:apply-templates select="spendingTrendsPart"/>
                                        </xsl:when>
                                        
                                        <!-- No payees -->
                                        <xsl:otherwise>
                                            <xsl:call-template name="SpendingTrendsEmpty"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>
                                
                                <xsl:choose>
                                    <!-- Do we have any upcoming transactions? -->
                                    <xsl:when test="count(upcomingTransactionsPart) and count(upcomingTransactionsPart/transaction)">
                                        <xsl:apply-templates select="upcomingTransactionsPart"/>
                                    </xsl:when>
                                    
                                    <!-- Do any smart transactions exist anywhere? -->
                                    <xsl:when test="count(upcomingTransactionsPart) and 0=count(upcomingTransactionsPart/transaction)">
                                        <xsl:call-template name="UpcomingTransactionsEmpty"/>
                                    </xsl:when>
                                    
                                    <!-- No upcoming transactions -->
                                    <xsl:otherwise>
                                        <xsl:call-template name="NoUpcomingTransactionsPresent"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                                
                                <xsl:choose>
                                    <!-- Do we have any budget goals? -->
                                    <xsl:when test="count(budgetGoalsPart)">
                                        <xsl:apply-templates select="budgetGoalsPart"/>
                                    </xsl:when>
                                    
                                    <xsl:otherwise>
                                        <xsl:call-template name="BudgetGoalsEmptyActive"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="count(spendingTrendsPart/QDev)">
                                        <xsl:call-template name="NetIncomeOverTime"/>
                                    </xsl:when>
                                    
                                </xsl:choose>
                                <xsl:choose>
                                    <xsl:when test="count(spendingTrendsPart/QDev)">
                                        <xsl:call-template name="SpendingOverTime"/>
                                    </xsl:when>
                                </xsl:choose>
                            </div>
                            
                            <xsl:apply-templates select="allAccountsPart"/>
                        </xsl:when>
                        
                        <!-- No accounts present -->
                        <xsl:otherwise>
                            <xsl:call-template name="NoAccountsPresent"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </body>
        </html>
    </xsl:template>
    
    
    <!-- Currencies -->
    
    <xsl:template match="currencies">
        <xsl:if test="count(currency) > 1">
            <div class="currencies_select_div">
                <select id="currencyTypeSelect">
                    <xsl:apply-templates select="currency"/>
                </select>
                <div class="select_arrow_wrapper">
                    <div class="arrow_up"></div>
                    <div class="arrow_down"></div>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    
    <xsl:template match="currency">
        <xsl:choose>
            <xsl:when test="@selected='YES'">
                <option value="{@currencyID}" selected=""><xsl:value-of select="@title"/></option>
            </xsl:when>
            <xsl:otherwise>
                <option value="{@currencyID}"><xsl:value-of select="@title"/></option>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <!-- Spending Trends Part -->
    
    <xsl:template match="spendingTrendsDates">
        <div class="time_frame_select_div">
            <select id="timeFrameSelect">
                <xsl:apply-templates select="option"/>
            </select>
            <div class="select_arrow_wrapper">
                <div class="arrow_up"></div>
                <div class="arrow_down"></div>
            </div>
        </div>
    </xsl:template>
    
    
    <xsl:template match="spendingTrendsDates/option">
        <xsl:choose>
            <xsl:when test="@value='currentMonth'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Month to Date (<xsl:value-of select="../@currentMonthName"/>)
                </option>
            </xsl:when>
            <xsl:when test="@value='lastMonth'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Last Month (<xsl:value-of select="../@lastMonthName"/>)
                </option>
            </xsl:when>
            <xsl:when test="@value='lastSixMonths'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Last 6 Months
                </option>
            </xsl:when>
            <xsl:when test="@value='last12Months'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Last 12 Months
                </option>
            </xsl:when>
            <xsl:when test="@value='yearToDate'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Year to Date
                </option>
            </xsl:when>
            <xsl:otherwise>
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Last Month (<xsl:value-of select="../@lastMonthName"/>)
                </option>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template match="spendingTrendsPart">
        <div class="slider_container">
            <div class="totalAmount"><xsl:value-of select="total"/></div>
            <div class="btn btn_prev">prev</div>
            
            <ul class="slider">
                <li class="one_slide"><h2>Spending By Category</h2><div id="spendingTrendsPlot" style="width: 720px; height: 300px; margin: 0 auto; display: block; float: left;"/>
                    <div class="stepAUncategorized"></div>
                </li>
                <li class="one_slide"><h2 class="spending_over_time_title hide">Spending Over Time</h2><div class="date_range"/><div id="spendingOvertimeChart" style="width: 680px; height: 300px; margin: 0 auto; display: block; float: left;"/></li>
                <li class="one_slide"><h2 class="net_income_title">Net Income</h2><div class="date_range"/><div id="netIncomeChart" style="width: 680px; height: 300px; margin-left: -20px; display: block; float: left;"/></li>
            </ul>
            
            <div class="btn btn_next">next</div>
            <div class="pagination">
                <div class="pagination_item"><a title="0">0</a></div>
                <div class="pagination_item"><a title="1">1</a></div>
                <div class="pagination_item"><a title="2">2</a></div>
            </div>
        </div>
        
        <div class="stepAContent">
            <div id="tableHolder"></div>
        </div>
        
        <div class="spendingTrendsKey">
            <div class="spendingTrendsTitle">Top <xsl:value-of select="count(payee)"/> Spending</div>
            <xsl:apply-templates select="payee"/>
        </div>
    </xsl:template>
    
    
    <xsl:template match="payee">
        <div class="payee">
            <span class="category"><xsl:value-of select="category"/></span>
            <span class="rawAmount"><xsl:value-of select="rawAmount"/></span>
            <span class="percentage"><xsl:value-of select="percentage"/>%</span>
            <span class="quickenID"><xsl:value-of select="quickenID"/></span>
            <span class="numberOfTxn"><xsl:value-of select="numberOfTxn"/></span>
            
            <xsl:choose>
                <xsl:when test="amount[@sign='negative']">
                    <span class='amount negative'><xsl:value-of select="amount"/></span>
                </xsl:when>
                <xsl:otherwise>
                    <span class='amount'><xsl:value-of select="amount"/></span>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    
    <!-- Upcoming Transactions Part -->
    
    <xsl:template match="upcomingTransactionsPart">
        <div id="stepBCont" class="section activeStep clearAfter">
            <xsl:call-template name="upcomingTransactionDates"/>
            <h2>Upcoming Bills &amp; Income</h2>
            
            <div class="hTodayMarkerOuter"></div>
            <div class="hTodayMarkerInner"></div>
            <table id="upcomingBillsTable" cellspacing="0" cellpadding="0" border="0">
                <xsl:apply-templates select="transaction"/>
            </table>
        </div>
    </xsl:template>
    
    
    <xsl:template name="upcomingTransactionDates">
        <div class="upcoming_days_select_div">
            <select id="upcomingDaysSelect">
                <xsl:apply-templates select="/root/upcomingTransactionDates/option"/>
            </select>
            <div class="select_arrow_wrapper">
                <div class="arrow_up"></div>
                <div class="arrow_down"></div>
            </div>
        </div>
    </xsl:template>
    
    
    <xsl:template match="upcomingTransactionDates/option">
        <xsl:choose>
            <xsl:when test="@value='next7Days'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Next 7 Days
                </option>
            </xsl:when>
            <xsl:when test="@value='next14Days'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Next 14 Days
                </option>
            </xsl:when>
            <xsl:when test="@value='next30Days'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Next 30 Days
                </option>
            </xsl:when>
            <xsl:when test="@value='next90Days'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Next 90 Days
                </option>
            </xsl:when>
            <xsl:otherwise test="@value='next7Days'">
                <option value="{@value}">
                    <xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
                    Next 7 Days
                </option>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template match="root/upcomingTransactionsPart/transaction">
        <xsl:choose>
            <xsl:when test="count(today)">
                <xsl:call-template name="TodayTransaction"/>
            </xsl:when>
            <xsl:when test="status='Due'">
                <xsl:call-template name="TransactionWithStatusClass">
                    <xsl:with-param name="statusClass">pastDueRow</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="status='Upcoming'">
                <xsl:call-template name="TransactionWithStatusClass">
                    <xsl:with-param name="statusClass">upcomingRow</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template name="TransactionWithStatusClass">
        <xsl:param name="statusClass" />
        
        <tr class="transactionRow {$statusClass}" quickenid="{quickenID}" rawdate="{rawDate}">
            <td class="billPayeeCol"><xsl:value-of select="payee"/></td>
            
            <xsl:choose>
                
                <xsl:when test="status='Due'">
                    <xsl:choose>
                        <xsl:when test="string(number(daysUntilDue)) = number(daysUntilDue)">
                            <td class="dueDateCol"><xsl:value-of select="daysUntilDue"/> days late</td>
                        </xsl:when>
                        
                        <xsl:otherwise>
                            <td class="dueDateCol"><xsl:value-of select="daysUntilDue"/></td>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="string(number(daysUntilDue)) = number(daysUntilDue)">
                            <td class="dueDateCol">Due in <strong><xsl:value-of select="daysUntilDue"/> days</strong></td>
                        </xsl:when>
                        
                        <xsl:otherwise>
                            <td class="dueDateCol"><xsl:value-of select="daysUntilDue"/></td>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:choose>
                <xsl:when test="count(noAmount)">
                    <td class="billTotalCol">no amount</td>
                </xsl:when>
                <xsl:when test="count(@isTransfer)">
                    <td class="billTotalCol"><span class="transferAmount"><xsl:value-of select="amount"/></span></td>
                </xsl:when>
                <xsl:when test="amount[@sign='positive']">
                    <td class="billTotalCol"><span class="posAmount"><xsl:value-of select="amount"/></span></td>
                </xsl:when>
                <xsl:when test="amount[@sign='negative']">
                    <td class="billTotalCol"><span class="negAmount"><xsl:value-of select="amount"/></span></td>
                </xsl:when>
            </xsl:choose>
        </tr>
    </xsl:template>
    
    
    <xsl:template name="TodayTransaction">
        <tr>
            <td class="today" colspan="3">Today<br /><span class="date"><xsl:value-of select="today"/></span></td>
        </tr>
    </xsl:template>
    
    
    <!-- Budget Goals -->
    
    <xsl:template match="budgetGoalsPart">
        <div id="stepCCont" class="section">
            <h2>Budget</h2>
            <div class="navItemButtonsSC">
                <a href="" class="prevItemButton"></a>
                <a href="" class="currentItemButton"></a>
                <a href="" class="nextItemButton"></a>
            </div>
            <xsl:choose>
                <xsl:when test="count(budget)>1">
                    <select id="upcomingMonthSelect">
                        <xsl:for-each select="budget">
                            
                            <xsl:choose>
                                <xsl:when test="@selected='YES'">
                                    <option value="{@quickenID}" selected="YES"><xsl:value-of select="@title"/>&#x0020;&#x2014;&#x0020;<xsl:value-of select="@dateRange"/></option>
                                </xsl:when>
                                
                                <xsl:otherwise>
                                    <option value="{@quickenID}"><xsl:value-of select="@title"/>&#x0020;&#x2014;&#x0020;<xsl:value-of select="@dateRange"/></option>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:for-each>
                    </select>
                </xsl:when>
                
                <xsl:otherwise>
                    <div id="upcomingMonthStatic"><xsl:value-of select="budget[1]/@dateRange"/></div>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:apply-templates select="budget"/>
        </div>
    </xsl:template>
    
    
    <!-- Budgets -->
    
    <xsl:template match="budget">
        <xsl:apply-templates select="budgetSection"/>
        <xsl:apply-templates select="totals"/>
    </xsl:template>
    
    
    <!-- Budget Sections -->
    
    <xsl:template match="budgetSection">
        
        <div class="savingsGoalsTableWrapper" id="{../@quickenID}">
            <!-- This first table contains the column titles and the first 8 rows -->
            <table class="savingsGoalsTable first" cellspacing="0" cellpadding="0">
                <thead>
                    <tr><th class="budgetSpacer"></th></tr>
                    <tr>
                        <th class="goalNameCol"><xsl:value-of select="@type"/></th>
                        <th class="goalPercentHdr"><span>0%</span>100%</th>
                        <th class="goalCol">Goal</th>
                        <th class="resultsCol">Results</th>
                    </tr>
                    <tr><th class="budgetSpacer"></th></tr>
                </thead>
                <!-- <tbody>
                 <xsl:call-template name="recursive_lineItem">
                 <xsl:with-param name="start"><xsl:value-of select="1"/></xsl:with-param>
                 <xsl:with-param name="end"><xsl:value-of select="9"/></xsl:with-param>
                 </xsl:call-template>
                 </tbody> -->
            </table>
            
            <!-- The middle table contains the main entries (if over the # that will fit in the last table)
             <xsl:if test="count(lineItem) &gt;= 9"> -->
            <!-- Recursively create the remaining table with page breaks inbetween-->
            <!-- Create a table for each $increment number of bars -->
            <!--<xsl:call-template name="recursive_budgetTable">
             <xsl:with-param name="start"><xsl:value-of select="9"/></xsl:with-param>
             <xsl:with-param name="end"><xsl:value-of select="count(lineItem)"/></xsl:with-param>
             <xsl:with-param name="increment"><xsl:value-of select="10"/></xsl:with-param>
             </xsl:call-template>
             </xsl:if> -->
            
            <!-- The last table contains a the total, if present -->
            <xsl:if test="count(@total)">
                <table id="{@quickenID}" class="savingsGoalsTable last" cellspacing="0" cellpadding="0">
                    <tbody>
                        <tr class="{@displayClass} budgetTotalRow">
                            <td class="goalNameCol">Budgeted <xsl:value-of select="@type"/></td>
                            <td class="goalPercentCol">
                                <div>
                                    <xsl:choose>
                                        <xsl:when test="@percent > 0">
                                            <span class="totalPercent" style="width:{@percent}%;">&#160;&#160;<xsl:value-of select="@total"/>&#160;&#160;</span>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <div>&#160;&#160;<xsl:value-of select="@total"/>&#160;&#160;</div>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>
                            </td>
                            <td class="goalCol"><xsl:value-of select="@target"/></td>
                            <td class="resultsCol"><xsl:value-of select="@remaining"/></td>
                        </tr>
                    </tbody>
                </table>
            </xsl:if>
            <xsl:if test="count(@today)">
                <div class="todayMarker">
                    <div class="todayFraction"><xsl:value-of select="@todayFraction"/></div>
                    <div class="vTodayMarkerOuter"></div>
                    <div class="vTodayMarkerInner">Today<br/><span><xsl:value-of select="@today"/></span></div>
                </div>
            </xsl:if>
        </div>
    </xsl:template>
    
    <!-- Budget Table -->
    <xsl:template name="recursive_budgetTable">
        <xsl:param name="start"/>
        <xsl:param name="end"/>
        <xsl:param name="increment"/>
        
        <!-- Break the pages before each of the new tables -->
        <div style="page-break-before: always; height:0px; width:100%"></div>
        
        <table id="{@quickenID}" class="savingsGoalsTable middle" cellspacing="0" cellpadding="0">
            <tbody>
                <xsl:call-template name="recursive_lineItem">
                    <xsl:with-param name="start"><xsl:value-of select="$start"/></xsl:with-param>
                    <xsl:with-param name="end"><xsl:value-of select="$start+$increment"/></xsl:with-param>
                </xsl:call-template>
            </tbody>
        </table>
        
        <xsl:if test="$start+$increment &lt;= $end">
            <xsl:call-template name="recursive_budgetTable">
                <xsl:with-param name="start"><xsl:value-of select="$start+$increment"/></xsl:with-param>
                <xsl:with-param name="end"><xsl:value-of select="$end"/></xsl:with-param>
                <xsl:with-param name="increment"><xsl:value-of select="$increment"/></xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <!-- Budget Line Items -->
    
    <xsl:template name="recursive_lineItem">
        <xsl:param name="start"/>
        <xsl:param name="end"/>
        
        <xsl:for-each select="lineItem">
            <xsl:if test="position() &gt;= $start and position() &lt; $end">
                <tr class="{@displayClass}">
                    <td class="goalNameCol">
                        <xsl:apply-templates select="userTag"/>
                        <xsl:apply-templates select="categoryTag"/>
                    </td>
                    <td class="goalPercentCol">
                        <div>
                            <xsl:choose>
                                <xsl:when test="@percent > 0">
                                    <span class="totalPercent" style="width:{@percent}%;">&#160;&#160;<xsl:value-of select="@total"/>&#160;&#160;</span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <div>&#160;&#160;<xsl:value-of select="@total"/>&#160;&#160;</div>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
                    </td>
                    <td class="goalCol"><xsl:value-of select="@target"/></td>
                    <td class="resultsCol"><xsl:value-of select="@remaining"/></td>
                </tr>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="userTag">
        <xsl:if test=". != ../userTag[1]">, </xsl:if>
        <xsl:value-of select="."/><xsl:text> (tag)</xsl:text>
    </xsl:template>
    
    <xsl:template match="categoryTag">
        <xsl:if test="(. != ../categoryTag[1]) or (count(../userTag))">, </xsl:if>
        <xsl:value-of select="."/>
    </xsl:template>
    
    <!-- Net Totals Section (hide from overview)-->
    
    <xsl:template match="totals">
        <div class="savingsGoalsTableWrapper hide" id="{../@quickenID}">
            <div class="netTotals">
                <table class="netTotalsBox" cellspacing="0" cellpadding="0">
                    <thead>
                        <tr>
                            <th class="goalNameCol"> </th>
                            <th class="goalCol">Budgeted</th>
                            <th class="resultsCol">Actual</th>
                            <th class="resultsCol">&#160;</th>
                        </tr>
                        <tr><th colspan="3"><div class="netDivLight" /></th></tr>
                    </thead>
                    <tr class="netSubTotal">
                        <td class="netItem">Budgeted Expenses: </td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="expenseTarget[@sign='negative']">
                                    <div class="netValue"><xsl:value-of select="expenseTarget"/></div>
                                </xsl:when>
                                <xsl:otherwise>
                                    <div class="netValue netNegative"><xsl:value-of select="expenseTarget"/></div>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="expenseTotal[@sign='negative']">
                                    <div class="netValue"><xsl:value-of select="expenseTotal"/></div>
                                </xsl:when>
                                <xsl:otherwise>
                                    <div class="netValue netNegative"><xsl:value-of select="expenseTotal"/></div>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                        <td>
                            <xsl:if test="count(expenseOver)">
                                <div class="netValue netNegative"><xsl:value-of select="expenseOver"/> Over</div>
                            </xsl:if>
                            <xsl:if test="count(expenseUnder)">
                                <div class="netValue netGray"><xsl:value-of select="expenseUnder"/> Under</div>
                            </xsl:if>
                        </td>
                    </tr>
                    <tr><td colspan="3"><div class="netDiv" /></td></tr>
                </table>
            </div>
        </div>
    </xsl:template>
    
    <!-- All Accounts Part -->
    
    <xsl:template match="allAccountsPart">
        <div id="yourAccountsCont">
            <h2 id="yourAccountsHdr">Your Accounts</h2>
            <ul class="accountList">
                <xsl:apply-templates select="accountGenre"/>
            </ul>
            <div class="netWorth">
                <xsl:choose>
                    <xsl:when test="netWorth[@sign='negative']">
                        <span class='netWorthTotalMinus'><xsl:value-of select="netWorth"/></span>
                    </xsl:when>
                    <xsl:otherwise>
                        <span class='netWorthTotal'><xsl:value-of select="netWorth"/></span>
                    </xsl:otherwise>
                </xsl:choose>
                Net Worth
            </div>
            <a class="buttonLink updateAllBtn" href="" title="Update All">Update All</a>
        </div>
    </xsl:template>
    
    
    <xsl:template match="accountGenre">
        <li class="opened">
            <xsl:choose>
                <xsl:when test="subtotal[@sign='negative']">
                    <span class="accountTotalMinus"><xsl:value-of select="subtotal"/></span>
                </xsl:when>
                <xsl:otherwise>
                    <span class="accountTotal"><xsl:value-of select="subtotal"/></span>
                </xsl:otherwise>
            </xsl:choose>
            <a href="#" title="{@title}"><xsl:value-of select="@title"/></a>
            <ul>
                <xsl:apply-templates select="account"/>
            </ul>
        </li>
    </xsl:template>
    
    
    <xsl:template match="account">
        <li>
            <a href="" onclick="return DisplayAccount({quickenID});" class="title">
                <xsl:choose>
                    <xsl:when test="balance[@sign='negative']">
                        <span class="accountTotalMinus"><xsl:value-of select="balance"/></span>
                    </xsl:when>
                    <xsl:otherwise>
                        <span class="accountTotal"><xsl:value-of select="balance"/></span>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="title"/>
            </a>
        </li>
        <!--
         <a href="" onclick="return DisplayAccount({quickenID});" class="title"><xsl:value-of select="title"/></a>
         <span class="balance">
         </span>
         <xsl:apply-templates select="lastDownloadDate"/>
         </li>-->
    </xsl:template>
    
    
    <xsl:template match="lastDownloadDate">
        <xsl:choose>
            <xsl:when test="string-length(.)">
                <span class="lastDownloadDate"><xsl:value-of select="."/></span>
            </xsl:when>
            <xsl:otherwise>
                <span class="lastDownloadDate never"></span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <!-- No Accounts Present -->
    
    <xsl:template name="NoAccountsPresent">
        <!-- Begin: innerWrapper -->
        <div id="zeroDataWrapper" class="fullWidth">
            <h1 id="pageTitle">Overview</h1>
            
            <!-- Begin: Step A -->
            <div id="stepACont" class="clearAfter section">
                <div class="pieGraphCont">
                    <img src="../images/placeholders/pie_graph.png" width="250" height="280" alt="Pie Graph" />
                </div>
                <div class="stepAContent activeStep">
                    <h2 id="seeWhereMoneyGoes" >See Where Your Money Goes</h2>
                    <p class="sectionDescrip">Get a picture of how much you&#8217;re spending</p>
                    <div class="whyDoThisCont">
                        <h3 class="question">Why Do This</h3>
                        <p class="answer">Knowing where you spend your money is an important first step in taking control of your finances.</p>
                    </div>
                    <div class="whatsNeededCont">
                        <h3 class="question">What&#8217;s Needed</h3>
                        <p class="answer">You&#8217;ll need the user IDs and passwords you use when you go to websites for your bank and credit cards.</p>
                    </div>
                    <a class="buttonLink getStartedLink" href="#" onclick="return ShowAssistant('step1')" title="Get Started">Get Started</a>
                    <img class="completeTime" src="../images/10_mins.png" width="78" height="77" alt="10 Mins" />
                </div>
            </div>
            <!-- End: Step A -->
            
            <!-- Begin: Step B -->
            <div id="stepBCont" class="section inactive">
                <h2 id="stayOnTop" >Stay on Top of Your Bills</h2>
                <p class="sectionDescrip">
                    Avoid late fees and overdraft charges with reminders of when bills are due and when paychecks are expected.
                </p>
                <img class="completeTime" src="../images/3_mins_inactive.png" width="78" height="77" alt="10 Mins" />
            </div>
            <!-- Begin: Step B -->
            
            <!-- Begin: Step C -->
            <div id="stepCCont" class="section inactive">
                <h2 id="setGoalsToSave" >Create a Budget</h2>
                <p class="sectionDescrip">
                    Planning monthly spending will help you save money month after month.
                </p>
                <img class="completeTime" src="../images/3_mins_inactive.png" width="78" height="77" alt="10 Mins" />
            </div>
            <!-- End: Step C -->
            
        </div>
        <!-- End: innerWrapper -->
    </xsl:template>
    
    
    <!-- No Spending Trend Payees -->
    
    <xsl:template name="SpendingTrendsEmpty">
        <div class="noDataA">
            <p class="first">You have no categorized spending for the selected date range.</p>
            <p class="second">Try selecting a different date range above.</p>
        </div>
    </xsl:template>
    
    
    <!-- Scheduled Transactions Exist, but none to display -->
    <xsl:template name="UpcomingTransactionsEmpty">
        <div id="stepBCont" class="section activeStep clearAfter">
            <xsl:call-template name="upcomingTransactionDates"/>
            <h2>Stay on Top of Your Bills</h2>
            
            <div class="noDataB">
                <p class="first">No Bills Due in Next
                    <xsl:call-template name="UpcomingTransactionsDayCount">
                        <xsl:with-param name="selectedDayCount" select="upcomingTransactionDates/option[@selected='YES']"/>
                    </xsl:call-template>
                    Days.</p>
                <p class="second">We Like That.</p>
            </div>
        </div>
    </xsl:template>
    
    
    <xsl:template name="UpcomingTransactionsDayCount">
        <xsl:param name="selectedDayCount"/>
        <xsl:choose>
            <xsl:when test="$selectedDayCount[@value='next7Days']">7</xsl:when>
            <xsl:when test="$selectedDayCount[@value='next14Days']">14</xsl:when>
            <xsl:when test="$selectedDayCount[@value='next30Days']">30</xsl:when>
            <xsl:when test="$selectedDayCount[@value='next90Days']">90</xsl:when>
            <xsl:otherwise test="@value='next7Days'">7</xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <!-- No Upcoming Transactions Present -->
    
    <xsl:template name="NoUpcomingTransactionsPresent">
        <div id="stepBCont" class="section activeStep clearAfter">
            <h2>Stay on Top of Your Bills</h2>
            <img class="exampleImage" src="../images/overview_step_B_example.png" width="263" height="190" alt="Overview Step B Example" />
            <div class="activeInstructions">
                <p class="sectionDescrip">
                    Quicken will scan your account history looking for regularly occuring bills and income. Quicken will then remind you when your bills are due and also project the impact of upcoming bills on bank and credit card balances.
                </p>
                <h3 class="question">Why do this?</h3>
                <p class="answer">
                    Avoid late fees and overdraft charges. See the effects of upcoming bills before they happen.
                </p>
                <h3 class="question">What&#8217;s needed</h3>
                <p class="answer">
                    Add all the accounts you pay bills from first (Checking, Credit Cards). Have a list of your regularly occurring bills and your regular income (like your paycheck) handy.
                </p>
                <a class="buttonLink getStartedLink" href="#" onclick="return ShowAssistant('step2')" title="Get Started">Get Started</a>
            </div>
            <img class="completeTime" src="../images/3_mins_small.png" width="63" height="67" alt="10 Mins" />
        </div>
    </xsl:template>
    
    
    <!-- Budget Goals Empty and Active -->
    
    <xsl:template name="BudgetGoalsEmptyActive">
        <div id="stepCCont" class="section activeStep">
            <h2>Create a Budget</h2>
            <img class="exampleImage" src="../images/overview_step_C_example.png" width="260" height="160" alt="Overview Step C Example" />
            <div class="activeInstructions">
                <p class="sectionDescrip">
                    Planning monthly spending will help you save money month after month. Quicken will scan your transactions history to help you create a comprehensive, 12-month budget.
                </p>
                <h3 class="question">Why do this?</h3>
                <p class="answer">Take control of your finances and meet your long-term financial goals.</p>
                <h3 class="question">What&#8217;s needed</h3>
                <p class="answer">
                    Add all the accounts you regularly spend from first (Checking, Credit Cards).
                </p>
                <a class="buttonLink getStartedLink" href="#" onclick="return ShowAssistant('step3')" title="Get Started">Get Started</a>
            </div>
            <img class="completeTime" src="../images/3_mins_small.png" width="63" height="67" alt="10 Mins" />
        </div>
    </xsl:template>
    
    <xsl:template name="NetIncomeOverTime">
        <div id="stepCCont" class="section activeStep">
            <h2>4. Net Income Overtime</h2>
            <div>
                <textarea rows="20" cols="100"  id="NetIncomeJSON" >
                </textarea>
                <script type="text/javascript">
                    
                    document.getElementById("NetIncomeJSON").innerHTML = window.viewController.GetNetIncomeOverTime();;
                </script>
            </div>
        </div>
    </xsl:template>
    <xsl:template name="SpendingOverTime">
        <div id="stepCCont" class="section activeStep">
            <h2>5. Spending Overtime</h2>
            <div>
                <textarea rows="20" cols="100"  id="SpendingJSON" >
                </textarea>
                <script type="text/javascript">
                    
                    document.getElementById("SpendingJSON").innerHTML = window.viewController.GetSpendingOverTime();
                </script>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>
